/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWField;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLData;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IField;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import filenet.vw.server.VWFieldUtility;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public final class VWFieldDefinition
extends VWMLABase
implements Serializable,
IVWField,
IField,
Cloneable {
    private static final long serialVersionUID = 7544L;
    private transient CEObjectInfo ceObjectInfo = null;
    protected String description = null;
    protected int fieldType;
    protected boolean isArray;
    protected int mergeType = 1;
    protected String name = null;
    protected String valueString = null;
    protected String xmlSchemaName = null;
    protected String xmlSchemaElement = null;
    protected VWGuid requiredClass = null;
    private boolean canAssign = true;
    private VWWorkflowDefinition myWorkflow = null;
    private VWWorkflowSignature myWorkflowSignature = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-09-29 01:28:07 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/22 $";
    }

    protected VWFieldDefinition(VWWorkflowDefinition theWorkflow, String theName, Object theValue) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setValue(theValue);
        this.setName(theName);
    }

    protected VWFieldDefinition(VWWorkflowDefinition theWorkflow, String theName, String theValueString, int theType, boolean theIsArray, boolean validateName) throws VWException {
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setValue(theValueString, theType, theIsArray);
        if (validateName) {
            this.setName(theName);
        } else {
            this.name = theName;
            this.canAssign = false;
        }
    }

    protected VWFieldDefinition(VWWorkflowSignature theSignature, String theName, String theValueString, int theType, boolean theIsArray, String theDescription, int theMergeType, boolean theCanAssign) throws VWException {
        if (theIsArray && theType == 2 && theName.equals("F_Trackers")) {
            theType = 64;
        }
        this.name = theName;
        this.description = theDescription;
        this.mergeType = theMergeType;
        this.setValue(theValueString, theType, theIsArray);
        this.canAssign = theCanAssign;
        this.myWorkflowSignature = theSignature;
    }

    protected VWWorkflowDefinition getWorkflowDefinition() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    public boolean getCanAssign() {
        return this.canAssign;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getMergeType() {
        return this.mergeType;
    }

    public void setMergeType(int theMergeType) throws VWException {
        if (!VWMergeType.isValid(theMergeType)) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidMergeType", "theMergeType is not a valid merge type value");
        }
        this.mergeType = theMergeType;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidName", "The field name is invalid, (null or zero length).");
        }
        if (theName.equals(this.name)) {
            return;
        }
        if (this.getWorkflowDefinition().isExistingFieldName(theName)) {
            throw new VWException("vw.api.VWFieldDefinitionFieldNameAlreadyExists", "The field name is invalid, (a field with the name \"{0}\" already exists in this workflow definition).", theName);
        }
        if (theName.equals("F_Trackers")) {
            if (this.fieldType != 64 || !this.isArray) {
                throw new VWException("vw.api.VWFieldDefinitionFieldNameFTrackersMustBeAParticipantArray", "The F_Trackers field must be a participant array field, attempting to make it a {0} field.", VWFieldType.getLocalizedString(this.fieldType) + (this.isArray ? "[]" : ""));
            }
        } else if (theName.equals("F_CaseFolder")) {
            if (this.fieldType != 512 || this.isArray) {
                throw new VWException("vw.api.VWFieldDefinitionFieldNameFCaseFolderMustBeASingleGuid", "The field name was attempted to be set to ''F_CaseFolder'' using an array value. A guid field type (VWFieldType.FIELD_TYPE_GUID) must be used for the F_CaseFolder field, rather than attempting to make it a {0} field.", VWFieldType.getLocalizedString(this.fieldType) + (this.isArray ? "[]" : ""));
            }
        } else if (theName.equals("F_CaseTask")) {
            if (this.fieldType != 512 || this.isArray) {
                throw new VWException("vw.api.VWFieldDefinitionFieldNameFCaseTaskMustBeASingleGuid", "The field name was attempted to be set to ''F_CaseTask'' using an array value. A guid field type (VWFieldType.FIELD_TYPE_GUID) must be used for the F_CaseTask field, rather than attempting to make it a {0} field.", VWFieldType.getLocalizedString(this.fieldType) + (this.isArray ? "[]" : ""));
            }
        } else if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidName2", "Syntax error in the field name \"{0}\". The field name supplied did not meet the naming requirements. A field name must begin with a letter, contain only letters, numbers or underscores, and have a length <= {1}. Additionally, the name cannot be a name reserved for IBM FileNet internal use (such as, a name begining with F_, or be a command keyword such as ''if'', or a function name such as ''userid'' or ''addminutes'').", theName, 128);
        }
        if (this.fieldType == 512 && !theName.startsWith("F_")) {
            throw new VWException("vw.api.VWFieldDefinitionCannotCreateUserDefinedGuidFields", "Error creating the field \"{0}\". User-defined Guid fields cannot be created.", theName);
        }
        this.name = theName;
    }

    public String getStringValue() {
        return this.valueString;
    }

    public Object getValue() {
        try {
            if (this.fieldType == 128) {
                return new VWXMLData(this.valueString, this.xmlSchemaName, this.xmlSchemaElement);
            }
            return VWFieldType.stringToValue(this.valueString, this.fieldType, this.isArray);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setValue(Object theValue) throws VWException {
        if (theValue == null) {
            throw new VWException("vw.api.VWFieldDefinitionNullValue", "theValue cannot be null.");
        }
        if (VWFieldType.isValid(theValue)) {
            this.fieldType = VWFieldType.getVWFieldType(theValue);
            this.isArray = theValue.getClass().isArray();
            if (this.isArray) {
                this.valueString = VWArrayHandler.convertArrayToString(theValue);
            } else {
                this.valueString = this.fieldType == 16 ? (theValue instanceof Date ? VWFieldUtility.convertDateToString(theValue) : theValue.toString()) : theValue.toString();
                switch (this.fieldType) {
                    case 16: 
                    case 32: 
                    case 64: 
                    case 512: {
                        this.valueString = "\"" + this.valueString + "\"";
                        break;
                    }
                    case 128: {
                        if (!(theValue instanceof VWXMLData)) break;
                        this.xmlSchemaElement = ((VWXMLData)theValue).getElementName();
                        this.xmlSchemaName = ((VWXMLData)theValue).getSchemaName();
                    }
                }
            }
        } else {
            throw new VWException("vw.api.VWFieldDefinitionInvalidValueType", "The Value is a {0}, which is not a supported type.", theValue.getClass().getName());
        }
    }

    public void setValue(String theValue, int theType, boolean theIsArray) throws VWException {
        if (theValue == null) {
            throw new VWException("vw.api.VWFieldDefinitionNullValue", "theValue cannot be null.");
        }
        if (theType == 256) {
            theType = 16;
        }
        if (!VWFieldType.isValid(theType)) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidValueType", "The type specified is {0}, which is not a valid type.", String.valueOf(theType));
        }
        this.fieldType = theType;
        this.isArray = theIsArray;
        this.valueString = theValue.trim();
    }

    public void setXMLSchemaName(String theSchemaName) throws VWException {
        if (this.fieldType != 128) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonXMLField", "Method call not valid for non-XML fields, field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        this.xmlSchemaName = theSchemaName;
    }

    public String getXMLSchemaName() throws VWException {
        if (this.fieldType != 128) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonXMLField", "Method call not valid for non-XML fields, field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        return this.xmlSchemaName;
    }

    public void setXMLSchemaElement(String theSchemaElement) throws VWException {
        if (this.fieldType != 128) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonXMLField", "Method call not valid for non-XML fields, field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        this.xmlSchemaElement = theSchemaElement;
    }

    public String getXMLSchemaElement() throws VWException {
        if (this.fieldType != 128) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonXMLField", "Method call not valid for non-XML fields, field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        return this.xmlSchemaElement;
    }

    public void setRequiredClass(VWGuid theRequiredClass) throws VWException {
        if (this.fieldType != 512) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonGuidField", "The required class was attempted to be set for a field that was not a guid type (VWFieldType.FIELD_TYPE_GUID): field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        this.requiredClass = theRequiredClass;
    }

    public VWGuid getRequiredClass() throws VWException {
        if (this.fieldType != 512) {
            throw new VWException("vw.api.VWFieldDefinitionInvalidCallNonGuidField", "Method call not valid for non-guid fields, field {0} is of type {1}.", this.name, VWFieldType.getLocalizedString(this.fieldType));
        }
        return this.requiredClass;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWFieldDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<Field\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        if (this.description != null) {
            theBuffer.append(ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.description) + "\"\n");
        }
        if (this.valueString != null) {
            theBuffer.append(ATTRIB_INDENT + "ValueExpr=\"" + VWXMLHandler.toXMLString(this.valueString) + "\"\n");
        }
        if (this.fieldType == 128 && this.xmlSchemaName != null) {
            theBuffer.append(ATTRIB_INDENT + "SchemaName=\"" + VWXMLHandler.toXMLString(this.xmlSchemaName) + "\"\n");
        }
        if (this.fieldType == 128 && this.xmlSchemaElement != null) {
            theBuffer.append(ATTRIB_INDENT + "ElementName=\"" + VWXMLHandler.toXMLString(this.xmlSchemaElement) + "\"\n");
        }
        if (this.fieldType == 512 && this.requiredClass != null) {
            theBuffer.append(ATTRIB_INDENT + "RequiredClass=\"" + VWXMLHandler.toXMLString(this.requiredClass.toString()) + "\"\n");
        }
        theBuffer.append(ATTRIB_INDENT + "Type=\"" + VWFieldType.typeToString(this.fieldType) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IsArray=\"" + VWXMLHandler.booleanToString(this.isArray) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "MergeType=\"" + VWXMLHandler.toXMLString(VWMergeType.typeToString(this.mergeType)) + "\"/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWFieldDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<DataField Id=\"" + VWXMLHandler.toXMLString(this.name) + "\" " + "IsArray=\"" + VWXMLHandler.booleanToString(this.isArray).toUpperCase() + "\">\n");
        theBuffer.append(indentB + "<DataType>\n");
        String dataType = VWFieldType.typeToString(this.fieldType);
        if (this.fieldType == 32 || this.fieldType == 64 || this.fieldType == 128 || this.fieldType == 512) {
            theBuffer.append(indentC + "<DeclaredType Id=\"" + dataType + "\"/>\n");
        } else {
            if ((dataType = dataType.toUpperCase()).equals("INT")) {
                dataType = "INTEGER";
            } else if (dataType.equals("TIME")) {
                dataType = "DATETIME";
            }
            theBuffer.append(indentC + "<BasicType Type=\"" + dataType + "\"/>\n");
        }
        theBuffer.append(indentB + "</DataType>\n");
        if (this.valueString != null) {
            theBuffer.append(indentB + "<InitialValue>" + VWXMLHandler.toXMLString(this.valueString) + "</InitialValue>\n");
        }
        if (this.description != null) {
            theBuffer.append(indentB + "<Description>" + VWXMLHandler.toXMLString(this.description) + "</Description>\n");
        }
        theBuffer.append(indentB + "<fn:Field MergeType=\"" + VWXMLHandler.toXMLString(VWMergeType.typeToString(this.mergeType)) + "\"");
        if (this.fieldType == 128 && this.xmlSchemaName != null) {
            theBuffer.append("\n" + indentC + "SchemaName=\"" + VWXMLHandler.toXMLString(this.xmlSchemaName) + "\"");
        }
        if (this.fieldType == 128 && this.xmlSchemaElement != null) {
            theBuffer.append("\n" + indentC + "ElementName=\"" + VWXMLHandler.toXMLString(this.xmlSchemaElement) + "\"");
        }
        if (this.fieldType == 512 && this.requiredClass != null) {
            theBuffer.append("\n" + indentC + "RequiredClass=\"" + VWXMLHandler.toXMLString(this.requiredClass.toString()) + "\"");
        }
        theBuffer.append("/>\n");
        theBuffer.append(indentA + "</DataField>\n");
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWString theMessage;
        VWValidationError theError;
        VWString theMessage2;
        VWWorkflowSignature myBaseWflSignature;
        block24: {
            if (this.myWorkflow == null) {
                throw new VWException("vw.api.VWFieldDefinitionNullWorkflow", "Cannot call validate on this field definition because it has no reference to a containing workflow definition.");
            }
            VWWorkflowSignature myWflSignature = this.myWorkflow.getWorkflowSignature(validationContext);
            myBaseWflSignature = this.myWorkflow.getBaseWorkflowSignature(validationContext);
            if (this.valueString != null && this.valueString.compareTo("") != 0) {
                VWCompiledExpr compRes = new VWCompiledExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(this.valueString, myWflSignature, myBaseWflSignature, null, null, false, compRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int i = 0; i < errorCount; ++i) {
                        String theMessage3 = "vw.api.VWFieldDefinitionSyntaxError" + theErrorStrings[i];
                        VWValidationError theError2 = new VWValidationError(4, 1, this.name, this.valueString, theMessage3, null);
                        validationContext.addValidationError(theError2);
                    }
                } else if (!VWFieldType.isCompatibleType(this.fieldType, compRes.getResultType())) {
                    VWString theMessage4 = new VWString("vw.api.VWFieldDefinitionIncompatibleExpressionType", "Field definition Incompatible value type found {0}, expected {1}", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.typeToString(this.fieldType) + (this.isArray ? "[ ]" : ""));
                    VWValidationError theError3 = new VWValidationError(4, 1, this.name, null, theMessage4.toString(), null);
                    validationContext.addValidationError(theError3);
                }
            } else if (this.valueString != null && this.valueString.compareTo("") == 0) {
                theMessage2 = new VWString("vw.api.VWFieldDefinitionEmptyFieldValue", "Field definition value expression has no value");
                theError = new VWValidationError(4, 1, this.name, this.valueString, theMessage2.toString(), null);
                validationContext.addValidationError(theError);
            } else if (this.valueString == null) {
                theMessage2 = new VWString("vw.api.VWFieldDefinitionFieldHasNullValue", "Field definition value expression is null");
                theError = new VWValidationError(4, 1, this.name, null, theMessage2.toString(), null);
                validationContext.addValidationError(theError);
            }
            if ((this.xmlSchemaName != null || this.xmlSchemaElement != null) && this.fieldType != 128) {
                theMessage2 = new VWString("vw.api.VWFieldDefinitionNonXMLFieldHasXMLAttributes", "Field definition has non-null schema name or element name, but the field is not an XML field.");
                theError = new VWValidationError(4, 1, this.name, null, theMessage2.toString(), null);
                validationContext.addValidationError(theError);
            }
            if (this.fieldType == 128 && this.xmlSchemaName == null && this.xmlSchemaElement != null) {
                theMessage2 = new VWString("vw.api.VWFieldDefinitionNonXMLFieldHasElementButNoSchema", "Field definition has an element name, {0}, but no schema name.", this.xmlSchemaElement);
                theError = new VWValidationError(4, 1, this.name, null, theMessage2.toString(), null);
                validationContext.addValidationError(theError);
            }
            if (this.fieldType == 128 && this.xmlSchemaName != null) {
                try {
                    this.myWorkflow.getSchema(this.xmlSchemaName);
                }
                catch (VWException e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isSchemaName(this.xmlSchemaName)) break block24;
                    theMessage = new VWString("vw.api.VWFieldDefinitionBadSchema", "Field definition has a schema name, {0}, which is not the name of a schema defined in this workflow definition.", this.xmlSchemaName);
                    VWValidationError theError4 = new VWValidationError(4, 1, this.name, null, theMessage.toString(), null);
                    validationContext.addValidationError(theError4);
                }
            }
        }
        if (this.fieldType == 512 && this.requiredClass != null && !this.requiredClass.isUndefined()) {
            theMessage2 = null;
            try {
                CEObjectInfo ceObjInfo = validationContext.getCEClassDefinition(this.requiredClass);
                if (ceObjInfo == null) {
                    theMessage2 = new VWString("vw.api.VWFieldDefinitionCannotRetrieveRequiredClass", "Can not retrieve the required class \"{0}\" for the field definition.", this.requiredClass);
                }
            }
            catch (VWException e) {
                theMessage2 = new VWString("vw.api.VWFieldDefinitionBadRequiredClass", "Field definition has a bad required class: {0}.  {1}", this.requiredClass, e.getMessage());
            }
            if (theMessage2 != null) {
                theError = new VWValidationError(4, 1, this.name, null, theMessage2.toString(), null);
                validationContext.addValidationError(theError);
            }
        }
        IField baseField = null;
        if (myBaseWflSignature != null) {
            try {
                baseField = myBaseWflSignature.getField(this.name);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!(baseField == null || this.name.equals("F_Trackers") || baseField.getFieldType() == this.fieldType && baseField.isArray() == this.isArray)) {
                theMessage = new VWString("vw.api.VWFieldDefinitionChangeInheritedFieldType", "Field definition named {0}, overrides a field definition of the same name in the parent workflow definition but the field type is different( {1} in the parent, {2} in this workflow definition).", this.name, VWFieldType.getLocalizedString(baseField.getFieldType()) + (baseField.isArray() ? "[]" : ""), VWFieldType.getLocalizedString(this.fieldType) + (this.isArray ? "[]" : ""));
                VWValidationError theError5 = new VWValidationError(4, 1, this.name, null, theMessage.toString(), null);
                validationContext.addValidationError(theError5);
            }
        }
    }

    public Object clone() {
        try {
            VWFieldDefinition fd = (VWFieldDefinition)super.clone();
            return fd;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected VWSession getSession() throws VWException {
        if (this.myWorkflow != null) {
            return this.myWorkflow.getSession();
        }
        if (this.myWorkflowSignature != null) {
            return this.myWorkflowSignature.getSession();
        }
        return null;
    }

    public CEObjectInfo getCEObjectInfo() {
        return this.ceObjectInfo;
    }

    protected void setCEObjectInfo(CEObjectInfo ceObjectInfo) {
        this.ceObjectInfo = ceObjectInfo;
    }
}

